/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ActivityLevelEnum;
import common.AimingPointEnum;
import common.Localizeable;
import common.StyleEnum;
import common.TriggerEnum;
import java.io.Serializable;

public class Strategy
implements Localizeable,
Serializable,
Cloneable {
    private TriggerEnum trigger;
    private StyleEnum style;
    private ActivityLevelEnum activity;
    private AimingPointEnum aiming;
    private AimingPointEnum defense;

    public Strategy(TriggerEnum trigger, StyleEnum style, ActivityLevelEnum activity, AimingPointEnum aiming, AimingPointEnum defense) {
        this.trigger = trigger;
        this.style = style;
        this.activity = activity;
        this.aiming = aiming;
        this.defense = defense;
        this.validate();
    }

    public Strategy() {
        this.trigger = TriggerEnum.NONE;
        this.style = StyleEnum.TOTAL_KILL;
        this.activity = ActivityLevelEnum.ZERO;
        this.aiming = AimingPointEnum.NONE;
        this.defense = AimingPointEnum.NONE;
        this.validate();
    }

    public Strategy(TriggerEnum trig) {
        this.trigger = trig;
        this.style = StyleEnum.STRIKE;
        this.activity = ActivityLevelEnum.FIVE;
        this.aiming = AimingPointEnum.NONE;
        this.defense = AimingPointEnum.NONE;
        this.validate();
    }

    public TriggerEnum getTrigger() {
        return this.trigger;
    }

    public StyleEnum getStyle() {
        return this.style;
    }

    public ActivityLevelEnum getActivity() {
        return this.activity;
    }

    public AimingPointEnum getAimPoint() {
        return this.aiming;
    }

    public AimingPointEnum getDefPoint() {
        return this.defense;
    }

    public void setTrigger(TriggerEnum trigger) {
        if (this.trigger != TriggerEnum.DEFAULT) {
            this.trigger = trigger;
        }
        this.validate();
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public void setActivity(ActivityLevelEnum activity) {
        this.activity = activity;
    }

    public void setAimPoint(AimingPointEnum aiming) {
        this.aiming = aiming;
    }

    public void setDefPoint(AimingPointEnum defense) {
        this.defense = defense;
    }

    private void validate() {
        if (this.trigger == TriggerEnum.NONE) {
            this.style = StyleEnum.TOTAL_KILL;
            this.activity = ActivityLevelEnum.ZERO;
            this.aiming = AimingPointEnum.NONE;
            this.defense = AimingPointEnum.NONE;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            Strategy s = (Strategy)o;
            if (this.trigger == s.trigger && this.style == s.style && this.activity == s.activity && this.aiming == s.aiming && this.defense == s.defense) {
                return true;
            }
        }
        return false;
    }

    public void localize() {
        this.trigger = TriggerEnum.get(this.trigger.value());
        this.style = StyleEnum.get(this.style.value());
        this.activity = ActivityLevelEnum.get(this.activity.value());
        this.aiming = AimingPointEnum.get(this.aiming.value());
        this.defense = AimingPointEnum.get(this.defense.value());
    }
}

