/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class StyleEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static StyleEnum TOTAL_KILL = new StyleEnum(1, "Total Kill");
    public static StyleEnum PARRY = new StyleEnum(2, "Parry");
    public static StyleEnum LUNGE = new StyleEnum(3, "Lunge");
    public static StyleEnum BASH = new StyleEnum(4, "Bash");
    public static StyleEnum SLASH = new StyleEnum(5, "Slash");
    public static StyleEnum STRIKE = new StyleEnum(6, "Strike");
    public static StyleEnum WALL_OF_STEEL = new StyleEnum(7, "Wall of Steel");
    public static StyleEnum ENGAGE_AND_WITHDRAW = new StyleEnum(8, "Engage & Withdraw");
    public static StyleEnum SURE_STRIKE = new StyleEnum(9, "Sure Strike");
    public static StyleEnum CALCULATED_ATTACK = new StyleEnum(10, "Calculated Attack");
    public static StyleEnum DEFEND = new StyleEnum(11, "Defend");
    public static StyleEnum COUNTERSTRIKE = new StyleEnum(12, "Counterstrike");
    public static StyleEnum OPPORTUNITY_THROW = new StyleEnum(13, "Opportunity Throw");
    public static StyleEnum DECOY = new StyleEnum(14, "Decoy");
    public static StyleEnum MARTIAL_COMBAT = new StyleEnum(15, "Martial Combat");
    private Integer value;
    private String name;
    private String description;

    protected StyleEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected StyleEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((StyleEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((StyleEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static StyleEnum get(String name) {
        return (StyleEnum)NAME2VALUE.get(name);
    }

    public static StyleEnum get(int value) {
        return (StyleEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((StyleEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<StyleEnum> v = new Vector<StyleEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            StyleEnum x = StyleEnum.get(i);
            if (x == null) continue;
            v.add(x);
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

