/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BloodChallenges;
import common.NewTeamAdjustments;
import common.TeamDescriptor;
import common.TurnNumber;
import common.WarriorCore;

public class TeamCore
extends TeamDescriptor {
    protected BloodChallenges bloodChallenges;

    public TeamCore(int teamNumber, int forManagerNumber, String teamName, int wins, int losses, int kills, boolean active, TurnNumber lastTurnRan, BloodChallenges bloodChallenges) {
        super(teamNumber, forManagerNumber, teamName, wins, losses, kills, active, lastTurnRan);
        this.bloodChallenges = bloodChallenges;
    }

    public BloodChallenges getBloodChallenges() {
        return this.bloodChallenges;
    }

    public void setBloodChallenges(BloodChallenges bloodChallenges) {
        this.bloodChallenges = bloodChallenges;
    }

    public void setFromReplacement(NewTeamAdjustments replacement) {
        this.name = replacement.getName();
        this.wins = 0;
        this.losses = 0;
        this.kills = 0;
        this.bloodChallenges = new BloodChallenges();
        for (int i = 0; i < this.getChildCount(); ++i) {
            WarriorCore warrior = (WarriorCore)this.getChild(i);
            warrior.setFromReplacement(replacement.getNewWarrior(i));
        }
    }

    public Object clone() {
        TeamCore t = (TeamCore)super.clone();
        t.bloodChallenges = (BloodChallenges)this.bloodChallenges.clone();
        return t;
    }

    public void localize() {
        super.localize();
        this.bloodChallenges.localize();
    }
}

