/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Descriptor;
import common.FightOptionsEnum;
import common.TurnNumber;
import common.WarriorDescriptor;

public class TeamDescriptor
extends Descriptor {
    protected boolean active;
    protected TurnNumber lastTurnRan;

    public TeamDescriptor(int teamNumber, int forManagerNumber, String teamName, int wins, int losses, int kills, boolean active, TurnNumber lastTurnRan) {
        super(teamNumber, forManagerNumber, teamName, wins, losses, kills);
        this.active = active;
        this.lastTurnRan = lastTurnRan;
    }

    public int getTeamNumber() {
        return this.number;
    }

    public int getForManagerNumber() {
        return this.parentNumber;
    }

    public String getTeamName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public TurnNumber getLastTurnRan() {
        return this.lastTurnRan;
    }

    public void setActive(boolean flag) {
        this.active = flag;
    }

    public boolean isBuiltIn() {
        return ((Descriptor)this.getParent()).isBuiltIn();
    }

    public boolean hasTeamFight() {
        return this.getTeamFightSize() > 0;
    }

    public int getTeamFightSize() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            WarriorDescriptor warrior = (WarriorDescriptor)this.getChild(i);
            if (warrior.getFightOptions() != FightOptionsEnum.TEAM_FIGHT) continue;
            ++count;
        }
        return count;
    }

    public boolean validateRunStatus() {
        if (this.isActive()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (((WarriorDescriptor)this.getChild(i)).isActive()) continue;
                return false;
            }
        }
        return true;
    }

    public int getEventEntryCount() {
        int total = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (((WarriorDescriptor)this.getChild(i)).getFightOptions() != FightOptionsEnum.EVENT) continue;
            ++total;
        }
        return total;
    }
}

