/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.WarriorDescriptor;
import java.text.DecimalFormat;

public class TextHelper {
    protected static final DecimalFormat df = new DecimalFormat("##0.00");

    public static String getRaceGenderText(WarriorDescriptor w) {
        StringBuffer sb = new StringBuffer();
        sb.append(w.getRace().name());
        sb.append(" ");
        sb.append(w.getGender().name());
        return sb.toString();
    }

    public static String getHeightText(int inches) {
        return inches > 0 ? String.valueOf(inches / 12) + "' " + String.valueOf(inches % 12) + "\"" : "";
    }

    public static String getWeightText(int pounds) {
        return pounds > 0 ? pounds + " lbs" : "";
    }

    public static String leftSubstring(String value, int size) {
        if (value.length() > size) {
            value = value.substring(0, size - 1);
        }
        return value;
    }

    public static String padRightJustifiedPercent(double percent, int fieldSize) {
        String value = TextHelper.formatPercent(percent);
        int valueLen = value.length();
        int pad = fieldSize - valueLen;
        if (pad < 0) {
            throw new RuntimeException("Value representation exceeds field size");
        }
        StringBuffer sb = new StringBuffer();
        if (pad > 0) {
            for (int j = 0; j < pad; ++j) {
                sb.append(" ");
            }
        }
        sb.append(value);
        return sb.toString();
    }

    public static String pad(int value, int fieldSize) {
        String valueStr = String.valueOf(value);
        int valueLen = valueStr.length();
        int pad = fieldSize - valueLen;
        if (pad < 0) {
            throw new RuntimeException("Value representation exceeds field size");
        }
        StringBuffer sb = new StringBuffer();
        if (pad > 0) {
            for (int j = 0; j < pad; ++j) {
                sb.append(0);
            }
        }
        sb.append(valueStr);
        return sb.toString();
    }

    public static String padLeftJustified(String value, int fieldSize) {
        int valueLen = value.length();
        int pad = fieldSize - valueLen;
        if (pad < 0) {
            throw new RuntimeException("Value representation exceeds field size");
        }
        StringBuffer sb = new StringBuffer(value);
        if (pad > 0) {
            for (int j = 0; j < pad; ++j) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String padRightJustified(String value, int fieldSize) {
        int valueLen = value.length();
        int pad = fieldSize - valueLen;
        if (pad < 0) {
            throw new RuntimeException("Value representation exceeds field size");
        }
        StringBuffer sb = new StringBuffer();
        if (pad > 0) {
            for (int j = 0; j < pad; ++j) {
                sb.append(" ");
            }
        }
        sb.append(value);
        return sb.toString();
    }

    public static String padCentered(String value, int fieldSize) {
        int j;
        int valueLen = value.length();
        int pad = fieldSize - valueLen;
        if (pad < 0) {
            throw new RuntimeException("Value representation exceeds field size");
        }
        int rpad = pad / 2;
        int lpad = pad / 2;
        if (rpad + lpad < pad) {
            ++rpad;
        }
        StringBuffer sb = new StringBuffer();
        if (lpad > 0) {
            for (j = 0; j < lpad; ++j) {
                sb.append(" ");
            }
        }
        sb.append(value);
        if (rpad > 0) {
            for (j = 0; j < rpad; ++j) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String formatPercent(double value) {
        return df.format(value);
    }
}

