/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class TrainEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static TrainEnum STRENGTH = new TrainEnum(-1, "Strength");
    public static TrainEnum DEXTERITY = new TrainEnum(-2, "Dexterity");
    public static TrainEnum CONSTITUTION = new TrainEnum(-3, "Constitution");
    public static TrainEnum INTELLIGENCE = new TrainEnum(-4, "Intelligence");
    public static TrainEnum PRESENCE = new TrainEnum(-5, "Presence");
    public static TrainEnum STILETTO = new TrainEnum(1, "Stiletto");
    public static TrainEnum KNIFE = new TrainEnum(2, "Knife");
    public static TrainEnum DAGGER = new TrainEnum(3, "Dagger");
    public static TrainEnum SHORT_SWORD = new TrainEnum(4, "Short Sword");
    public static TrainEnum EPEE = new TrainEnum(5, "Epee");
    public static TrainEnum BROAD_SWORD = new TrainEnum(6, "Broadsword");
    public static TrainEnum BASTARD_SWORD = new TrainEnum(7, "Bastard Sword");
    public static TrainEnum GREAT_SWORD = new TrainEnum(8, "Great Sword");
    public static TrainEnum HATCHET = new TrainEnum(9, "Hatchet");
    public static TrainEnum FRANCISCA = new TrainEnum(10, "Francisca");
    public static TrainEnum BATTLE_AXE = new TrainEnum(11, "Battle Axe");
    public static TrainEnum GREAT_AXE = new TrainEnum(12, "Great Axe");
    public static TrainEnum SMALL_PICK = new TrainEnum(13, "Small Pick");
    public static TrainEnum MILITARY_PICK = new TrainEnum(14, "Military Pick");
    public static TrainEnum HAMMER = new TrainEnum(15, "Hammer");
    public static TrainEnum MACE = new TrainEnum(16, "Mace");
    public static TrainEnum MORNINGSTAR = new TrainEnum(17, "Morningstar");
    public static TrainEnum WAR_HAMMER = new TrainEnum(18, "War Hammer");
    public static TrainEnum MAUL = new TrainEnum(19, "Maul");
    public static TrainEnum BOAR_SPEAR = new TrainEnum(20, "Boar Spear");
    public static TrainEnum LONG_SPEAR = new TrainEnum(21, "Long Spear");
    public static TrainEnum POLE_AXE = new TrainEnum(22, "Pole Axe");
    public static TrainEnum HALBERD = new TrainEnum(23, "Halberd");
    public static TrainEnum FLAIL = new TrainEnum(24, "Flail");
    public static TrainEnum BLADED_FLAIL = new TrainEnum(25, "Bladed Flail");
    public static TrainEnum WAR_FLAIL = new TrainEnum(26, "War Flail");
    public static TrainEnum BATTLE_FLAIL = new TrainEnum(27, "Battle Flail");
    public static TrainEnum QUARTERSTAFF = new TrainEnum(28, "Quarterstaff");
    public static TrainEnum OPEN_HAND = new TrainEnum(29, "Open Hand");
    public static TrainEnum BUCKLER = new TrainEnum(30, "Buckler");
    public static TrainEnum TARGET_SHIELD = new TrainEnum(31, "Target Shield");
    public static TrainEnum TOWER_SHIELD = new TrainEnum(32, "Tower Shield");
    public static TrainEnum CESTUS = new TrainEnum(33, "Cestus");
    public static TrainEnum TRIDENT = new TrainEnum(34, "Trident");
    public static TrainEnum NET = new TrainEnum(35, "Net");
    public static TrainEnum SCYTHE = new TrainEnum(36, "Scythe");
    public static TrainEnum GREAT_PICK = new TrainEnum(37, "Great Pick");
    public static TrainEnum JAVELIN = new TrainEnum(38, "Javelin");
    public static TrainEnum BALL_CHAIN = new TrainEnum(39, "Ball & Chain");
    public static TrainEnum SWORDBREAKER = new TrainEnum(40, "Swordbreaker");
    public static TrainEnum LONG_SWORD = new TrainEnum(41, "Longsword");
    public static TrainEnum PICK_AXE = new TrainEnum(42, "Pick Axe");
    public static TrainEnum GREAT_STAFF = new TrainEnum(43, "Great Staff");
    public static TrainEnum SCIMITAR = new TrainEnum(44, "Scimitar");
    public static TrainEnum DODGE = new TrainEnum(51, "Dodge");
    public static TrainEnum PARRY = new TrainEnum(52, "Parry");
    public static TrainEnum THROW = new TrainEnum(53, "Throw");
    public static TrainEnum CHARGE = new TrainEnum(54, "Charge");
    public static TrainEnum LUNGE = new TrainEnum(55, "Lunge");
    public static TrainEnum DISARM = new TrainEnum(56, "Disarm");
    public static TrainEnum INITIATIVE = new TrainEnum(57, "Initiative");
    public static TrainEnum FEINT = new TrainEnum(58, "Feint");
    public static TrainEnum BRAWL = new TrainEnum(59, "Brawl");
    public static TrainEnum SWEEP = new TrainEnum(60, "Sweep");
    private Integer value;
    private String name;
    private String description;

    protected TrainEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected TrainEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((TrainEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((TrainEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static TrainEnum get(String name) {
        return (TrainEnum)NAME2VALUE.get(name);
    }

    public static TrainEnum get(int value) {
        return (TrainEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((TrainEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        TrainEnum skill;
        int i;
        Vector<TrainEnum> v = new Vector<TrainEnum>(MAX_VALUE);
        for (i = -1; i >= MIN_VALUE; --i) {
            skill = TrainEnum.get(i);
            if (skill == null) continue;
            v.add(skill);
        }
        for (i = 1; i <= MAX_VALUE; ++i) {
            skill = TrainEnum.get(i);
            if (skill == null) continue;
            v.add(skill);
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

