/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class TriggerEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static TriggerEnum NONE = new TriggerEnum(0, "None");
    public static TriggerEnum MINUTE_1 = new TriggerEnum(1, "Minute 1");
    public static TriggerEnum MINUTE_2 = new TriggerEnum(2, "Minute 2");
    public static TriggerEnum MINUTE_3 = new TriggerEnum(3, "Minute 3");
    public static TriggerEnum MINUTE_4 = new TriggerEnum(4, "Minute 4");
    public static TriggerEnum MINUTE_5 = new TriggerEnum(5, "Minute 5");
    public static TriggerEnum MINUTE_6 = new TriggerEnum(6, "Minute 6");
    public static TriggerEnum MINUTE_7 = new TriggerEnum(7, "Minute 7");
    public static TriggerEnum MINUTE_8 = new TriggerEnum(8, "Minute 8");
    public static TriggerEnum MINUTE_9 = new TriggerEnum(9, "Minute 9");
    public static TriggerEnum MINUTE_10 = new TriggerEnum(10, "Minute 10");
    public static TriggerEnum YOU_ARE_VERY_TIRED = new TriggerEnum(31, "You are very tired");
    public static TriggerEnum FOE_IS_VERY_TIRED = new TriggerEnum(32, "Your foe is very tired");
    public static TriggerEnum YOU_ARE_SOMEWHAT_TIRED = new TriggerEnum(33, "You are somewhat tired");
    public static TriggerEnum FOE_IS_SOMEWHAT_TIRED = new TriggerEnum(34, "Your foe is somewhat tired");
    public static TriggerEnum YOU_ARE_SLIGHTLY_TIRED = new TriggerEnum(35, "You are slightly tired");
    public static TriggerEnum FOE_IS_SLIGHTLY_TIRED = new TriggerEnum(36, "Your foe is slightly tired");
    public static TriggerEnum YOU_TAKEN_HEAVY_DAMAGE = new TriggerEnum(41, "You have taken heavy damage");
    public static TriggerEnum FOE_TAKEN_HEAVY_DAMAGE = new TriggerEnum(42, "Your foe has taken heavy damage");
    public static TriggerEnum YOU_TAKEN_MEDIUM_DAMAGE = new TriggerEnum(43, "You have taken medium damage");
    public static TriggerEnum FOE_TAKEN_MEDIUM_DAMAGE = new TriggerEnum(44, "Your foe has taken medium damage");
    public static TriggerEnum YOU_TAKEN_SLIGHT_DAMAGE = new TriggerEnum(45, "You have taken slight damage");
    public static TriggerEnum FOE_TAKEN_SLIGHT_DAMAGE = new TriggerEnum(46, "Your foe has taken slight damage");
    public static TriggerEnum YOU_CHALLENGED = new TriggerEnum(51, "You challenged your foe");
    public static TriggerEnum FOE_CHALLENGED = new TriggerEnum(52, "Your foe challenged you");
    public static TriggerEnum YOU_BLOOD_CHALLENGED = new TriggerEnum(53, "You blood challenged your foe");
    public static TriggerEnum FOE_BLOOD_CHALLENGED = new TriggerEnum(54, "Your foe blood challenged you");
    public static TriggerEnum YOU_ARE_ON_GROUND = new TriggerEnum(61, "You are on the ground");
    public static TriggerEnum FOE_IS_ON_GROUND = new TriggerEnum(62, "Your foe is on the ground");
    public static TriggerEnum YOU_ARE_WEAPONLESS = new TriggerEnum(63, "You are weaponless");
    public static TriggerEnum FOE_IS_WEAPONLESS = new TriggerEnum(64, "Foe is weaponless");
    public static TriggerEnum NO_THROWABLE = new TriggerEnum(65, "You have no throwable weapons");
    public static TriggerEnum AT_LEAST_ONE_THROWABLE = new TriggerEnum(66, "You have at least 1 throwable weapon");
    public static TriggerEnum EXACTLY_ONE_THROABLE = new TriggerEnum(67, "You have exactly 1 throwable weapon");
    public static TriggerEnum EXACTLY_ONE_WEAPON = new TriggerEnum(68, "You have exactly 1 weapon");
    public static TriggerEnum EXACTLY_TWO_WEAPONS = new TriggerEnum(69, "You have exactly 2 weapons");
    public static TriggerEnum MORE_THAN_TWO_WEAPONS = new TriggerEnum(70, "You have more than 2 weapons");
    public static TriggerEnum FOE_LIGHT_ARMOR = new TriggerEnum(71, "Your foe is wearing light armor");
    public static TriggerEnum FOE_MEDIUM_ARMOR = new TriggerEnum(72, "Your foe is wearing medium armor");
    public static TriggerEnum FOR_HEAVY_ARMOR = new TriggerEnum(73, "Your foe is wearing heavy armor");
    public static TriggerEnum DEFAULT = new TriggerEnum(99, "Always");
    private Integer value;
    private String name;
    private String description;

    protected TriggerEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected TriggerEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((TriggerEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((TriggerEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static TriggerEnum get(String name) {
        return (TriggerEnum)NAME2VALUE.get(name);
    }

    public static TriggerEnum get(int value) {
        return (TriggerEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((TriggerEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<TriggerEnum> v = new Vector<TriggerEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            TriggerEnum x = TriggerEnum.get(i);
            if (x == null || x == DEFAULT) continue;
            v.add(x);
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

