/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;

public class TurnNumber
implements Serializable,
Comparable {
    private int turnSequence;
    private int turnSeries;

    public TurnNumber(int turnSequence) {
        this.turnSequence = turnSequence;
        this.turnSeries = 0;
    }

    public TurnNumber(int turnSequence, int turnSeries) {
        if (turnSeries < 0 || turnSeries > 9) {
            throw new RuntimeException("Turn series " + turnSeries + " is out of range");
        }
        this.turnSequence = turnSequence;
        this.turnSeries = turnSeries;
    }

    public int getTurnSequence() {
        return this.turnSequence;
    }

    public int getTurnSeries() {
        return this.turnSeries;
    }

    public String toString() {
        return this.turnSequence + (this.turnSeries > 0 ? "." + this.turnSeries : "");
    }

    public void incrementSequence() {
        ++this.turnSequence;
        this.turnSeries = 0;
    }

    public void incrementSeries() {
        ++this.turnSeries;
        if (this.turnSeries < 0 || this.turnSeries > 9) {
            throw new RuntimeException("Turn series " + this.turnSeries + " is out of range");
        }
    }

    public int compareTo(Object o) {
        TurnNumber ti = (TurnNumber)o;
        if (this.turnSequence < ti.turnSequence) {
            return -1;
        }
        if (this.turnSequence > ti.turnSequence) {
            return 1;
        }
        if (this.turnSeries < ti.turnSeries) {
            return -1;
        }
        if (this.turnSeries > ti.turnSeries) {
            return 1;
        }
        return 0;
    }

    public int difference(TurnNumber other) {
        return this.turnSequence - other.turnSequence;
    }
}

