/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ArmorEnum;
import common.BloodCrys;
import common.Challenges;
import common.FightOptionsEnum;
import common.GenderEnum;
import common.HelmEnum;
import common.NewWarriorAdjustments;
import common.NewWarriorBase;
import common.Perms;
import common.RaceEnum;
import common.Refusals;
import common.Skills;
import common.Strategies;
import common.Trains;
import common.WarriorDescriptor;
import common.WarriorStats;
import common.WarriorStatusEnum;
import common.WeaponEnum;

public class WarriorCore
extends WarriorDescriptor
implements WarriorStats {
    protected int strength;
    protected int dexterity;
    protected int constitution;
    protected int intelligence;
    protected int presence;
    protected int size;
    protected int sstrength;
    protected int sdexterity;
    protected int sconstitution;
    protected int sintelligence;
    protected int spresence;
    protected int ssize;
    protected ArmorEnum armor;
    protected HelmEnum helm;
    protected WeaponEnum primary;
    protected WeaponEnum secondary;
    protected WeaponEnum backup;
    protected Trains trains;
    protected Skills skillLevels;
    protected Perms permLevels;
    protected Strategies strategies;
    protected Challenges challenges;
    protected Refusals refusals;
    protected BloodCrys bloodCrys;
    protected NewWarriorBase replacementBase;

    public WarriorCore(int warriorNumber, int forTeamNumber, String warriorName, RaceEnum race, GenderEnum gender, int wins, int losses, int kills, int height, int weight, WarriorStatusEnum status, FightOptionsEnum fightOptions, int strength, int dexterity, int constitution, int intelligence, int presence, int size, int sstrength, int sdexterity, int sconstitution, int sintelligence, int spresence, int ssize, ArmorEnum armor, HelmEnum helm, WeaponEnum primary, WeaponEnum secondary, WeaponEnum backup, Trains trains, Skills skillLevels, Perms permLevels, Strategies strategies, Challenges challenges, Refusals refusals, BloodCrys bloodCrys, NewWarriorBase replacementBase) {
        super(warriorNumber, forTeamNumber, warriorName, race, gender, wins, losses, kills, height, weight, status, fightOptions);
        this.strength = strength;
        this.dexterity = dexterity;
        this.constitution = constitution;
        this.intelligence = intelligence;
        this.presence = presence;
        this.size = size;
        this.sstrength = sstrength;
        this.sdexterity = sdexterity;
        this.sconstitution = sconstitution;
        this.sintelligence = sintelligence;
        this.spresence = spresence;
        this.ssize = ssize;
        this.armor = armor;
        this.helm = helm;
        this.primary = primary;
        this.secondary = secondary;
        this.backup = backup;
        this.trains = trains;
        this.skillLevels = skillLevels;
        this.permLevels = permLevels;
        this.strategies = strategies;
        this.challenges = challenges;
        this.refusals = refusals;
        this.bloodCrys = bloodCrys;
        this.replacementBase = replacementBase;
    }

    public int getStr() {
        return this.strength;
    }

    public int getDex() {
        return this.dexterity;
    }

    public int getCon() {
        return this.constitution;
    }

    public int getInt() {
        return this.intelligence;
    }

    public int getPre() {
        return this.presence;
    }

    public int getSiz() {
        return this.size;
    }

    public int getSStr() {
        return this.sstrength;
    }

    public int getSDex() {
        return this.sdexterity;
    }

    public int getSCon() {
        return this.sconstitution;
    }

    public int getSInt() {
        return this.sintelligence;
    }

    public int getSPre() {
        return this.spresence;
    }

    public int getSSiz() {
        return this.ssize;
    }

    public ArmorEnum getArmor() {
        return this.armor;
    }

    public HelmEnum getHelm() {
        return this.helm;
    }

    public WeaponEnum getPWeapon() {
        return this.primary;
    }

    public WeaponEnum getSWeapon() {
        return this.secondary;
    }

    public WeaponEnum getBWeapon() {
        return this.backup;
    }

    public Challenges getChallenges() {
        return this.challenges;
    }

    public Refusals getRefusals() {
        return this.refusals;
    }

    public Trains getTrains() {
        return this.trains;
    }

    public Skills getSkillLevels() {
        return this.skillLevels;
    }

    public Perms getPermLevels() {
        return this.permLevels;
    }

    public Strategies getStrategies() {
        return this.strategies;
    }

    public BloodCrys getBloodCrys() {
        return this.bloodCrys;
    }

    public NewWarriorBase getReplacementBase() {
        return this.replacementBase;
    }

    public void setArmor(ArmorEnum a) {
        this.armor = a;
    }

    public void setHelm(HelmEnum h) {
        this.helm = h;
    }

    public void setPWeapon(WeaponEnum w) {
        this.primary = w;
    }

    public void setSWeapon(WeaponEnum w) {
        this.secondary = w;
    }

    public void setBWeapon(WeaponEnum w) {
        this.backup = w;
    }

    public void setChallenges(Challenges c) {
        this.challenges = c;
    }

    public void setRefusals(Refusals r) {
        this.refusals = r;
    }

    public void setTrains(Trains t) {
        this.trains = t;
    }

    public void setStrategies(Strategies s) {
        this.strategies = s;
    }

    public void setBloodCrys(BloodCrys b) {
        this.bloodCrys = b;
    }

    public void setFromReplacement(NewWarriorAdjustments replacement) {
        this.name = replacement.getName();
        this.race = replacement.getRace();
        this.gender = replacement.getGender();
        this.strength = replacement.getStr();
        this.dexterity = replacement.getDex();
        this.constitution = replacement.getCon();
        this.intelligence = replacement.getInt();
        this.presence = replacement.getPre();
        this.size = replacement.getSiz();
        this.sstrength = replacement.getStr();
        this.sdexterity = replacement.getDex();
        this.sconstitution = replacement.getCon();
        this.sintelligence = replacement.getInt();
        this.spresence = replacement.getPre();
        this.ssize = replacement.getSiz();
        this.wins = 0;
        this.losses = 0;
        this.kills = 0;
        this.height = 0;
        this.weight = 0;
        this.status = WarriorStatusEnum.ACTIVE;
        this.fightOptions = FightOptionsEnum.SINGLES_FIGHT;
        this.armor = ArmorEnum.NONE;
        this.helm = HelmEnum.NONE;
        this.primary = WeaponEnum.OPEN_HAND;
        this.secondary = WeaponEnum.OPEN_HAND;
        this.backup = WeaponEnum.OPEN_HAND;
        this.trains = new Trains();
        this.skillLevels = new Skills();
        this.permLevels = new Perms();
        this.challenges = new Challenges();
        this.refusals = new Refusals();
    }

    public Object clone() {
        WarriorCore w = (WarriorCore)super.clone();
        w.skillLevels = (Skills)this.skillLevels.clone();
        w.permLevels = (Perms)this.permLevels.clone();
        w.strategies = (Strategies)this.strategies.clone();
        w.bloodCrys = (BloodCrys)this.bloodCrys.clone();
        if (this.replacementBase != null) {
            w.replacementBase = (NewWarriorBase)this.replacementBase.clone();
        }
        return w;
    }

    public void localize() {
        super.localize();
        this.armor = ArmorEnum.get(this.armor.value());
        this.helm = HelmEnum.get(this.helm.value());
        this.primary = WeaponEnum.get(this.primary.value());
        this.secondary = WeaponEnum.get(this.secondary.value());
        this.backup = WeaponEnum.get(this.backup.value());
        this.trains.localize();
        this.strategies.localize();
        this.challenges.localize();
        this.refusals.localize();
        this.skillLevels.localize();
        this.permLevels.localize();
        this.bloodCrys.localize();
        if (this.replacementBase != null) {
            this.replacementBase.localize();
        }
    }
}

