/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Descriptor;
import common.FightOptionsEnum;
import common.GenderEnum;
import common.RaceEnum;
import common.WarriorStatusEnum;

public class WarriorDescriptor
extends Descriptor {
    protected RaceEnum race;
    protected GenderEnum gender;
    protected int height;
    protected int weight;
    protected WarriorStatusEnum status;
    protected FightOptionsEnum fightOptions;

    public WarriorDescriptor(int warriorNumber, int forTeamNumber, String warriorName, RaceEnum race, GenderEnum gender, int wins, int losses, int kills, int height, int weight, WarriorStatusEnum status, FightOptionsEnum fightOptions) {
        super(warriorNumber, forTeamNumber, warriorName, wins, losses, kills);
        this.race = race;
        this.gender = gender;
        this.height = height;
        this.weight = weight;
        this.status = status;
        this.fightOptions = fightOptions;
    }

    public int getWarriorNumber() {
        return this.number;
    }

    public int getForTeamNumber() {
        return this.parentNumber;
    }

    public String getWarriorName() {
        return this.name;
    }

    public RaceEnum getRace() {
        return this.race;
    }

    public GenderEnum getGender() {
        return this.gender;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isActive() {
        return this.status == WarriorStatusEnum.ACTIVE;
    }

    public boolean isDead() {
        return this.status == WarriorStatusEnum.DEAD;
    }

    public boolean isRetired() {
        return this.status == WarriorStatusEnum.RETIRED;
    }

    public boolean isDeadOrRetired() {
        return this.status == WarriorStatusEnum.DEAD || this.status == WarriorStatusEnum.RETIRED;
    }

    public WarriorStatusEnum getStatus() {
        return this.status;
    }

    public FightOptionsEnum getFightOptions() {
        return this.fightOptions;
    }

    public void setFightOptions(FightOptionsEnum fopt) {
        this.fightOptions = fopt;
    }

    public boolean isBuiltIn() {
        return ((Descriptor)this.getParent()).isBuiltIn();
    }

    public int getCurrentWins() {
        return this.getWins();
    }

    public int getCurrentLosses() {
        return this.getLosses();
    }

    public int getCurrentKills() {
        return this.getKills();
    }

    public int getCurrentTotalFights() {
        return this.getTotalFights();
    }

    public String getNameNumberText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" (");
        sb.append(((Descriptor)this.getParent()).getNumber());
        sb.append(")");
        return sb.toString();
    }

    public void localize() {
        super.localize();
        this.race = RaceEnum.get(this.race.value());
        this.gender = GenderEnum.get(this.gender.value());
        this.status = WarriorStatusEnum.get(this.status.value());
        this.fightOptions = FightOptionsEnum.get(this.fightOptions.value());
    }
}

